/*
 * Created on Aug 7, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package AppletInterface;

import java.net.*;
import java.io.*;
import java.awt.*;
import DatabaseCommunication.*;
import DataClasses.*;

import amber.type.server.*;
import amber.server.application.*;
import amber.client.RConstants;


/**
  * This is the Application Handler.
  *
  * @author Insert your name here
  * @version 1.0.0
  * @see amber.server.application.ApplicationHandler
*/

/**
 * @author student
 *
 * This class is being used as a host supporting all the frames. This
 * class manages communication with Amber server.
 * 
 */
public class StockTradingApplication extends ApplicationHandler {
	private Stock_Data[] stocks;

	//The following variables ensure that there is only one
	//set of data.. these variables are accessed and updated by 
	//LoginFrame, MainFrame, BuyFrame, SellFrame and UpdateFrame.
	private User_Data user;
	private UserAddress_Data address;

	/**
	  * Declare any panels or frames this application uses.
	  * Note that each panel/frame corresponds to one APPLET tag in the HTML.
	  * Also note that the panel/frame ID must match the ID parameter in the html.
	*/

	private LoginFrame frmLogin = new LoginFrame(0, this);
	
	/**
	 * This is the constructor for StockTradingApplication.java
	 */
	public StockTradingApplication() throws IOException {
		super(0, RConstants.InvalidPageSubId);
		defineComponents();
	}

	/**
	  * The initialising constructor.
	  * @param appIdentifier An int uniquely identifying this instance of application.
	*/
	public StockTradingApplication(int appIdentifier) throws IOException {
		super(appIdentifier, RConstants.InvalidPageSubId);
		defineComponents();
	}

	/**
	  * The initialising constructor.
	  * @param appIdentifier An int uniquely identifying this instance of application.
	  * @param newConnection The Socket which is connected to the page in operation.
	*/
	public StockTradingApplication(int appIdentifier, Socket newConnection)
		throws IOException {
		super(appIdentifier, RConstants.InvalidPageSubId, newConnection);
		defineComponents();
	}

	/**
		* Do initialisation that needs to be done within the constructor,
		* eg add any panels/frames this application uses.
		* Use "add" to add the component into the application
		* messaging loop.
	*/
	protected void defineComponents() {
		StockManager stockManager = new StockManager();
		stocks = stockManager.readAllStocks();
		// Add any panels/frames the application will use here.
		// add (pnlUntitled, new XYConstraints (40, 40, 30, 30));
		LoginFrame pnlLogin = new LoginFrame(0, this);
		//add (pnlLogin, getCentredWindowXYConstraints(LoginFrame.DIALOGWIDTH, LoginFrame.DIALOGHEIGHT));
		add(pnlLogin, new XYConstraints(100, 100, 800, 600));
		//LoginFrame.DIALOGWIDTH, LoginFrame.DIALOGHEIGHT));
		pnlLogin.setVisible(true);
	}

	/**
	 * This method is being used for getting appropriate x, and y co- 
	 * ordinates to support the specified width and height.
	 * @param windowWidth Width of the frame.
	 * @param windowHeight Height of the frame.
	 * @return XYConstraints The dimensions of the frame.
	 */
	public XYConstraints getCentredWindowXYConstraints(
		int windowWidth,
		int windowHeight) {
		Dimension d = getClientScreenSize();
		int x = ((int) d.getWidth() / 2) - (windowWidth / 2);
		int y = ((int) d.getHeight() / 2) - (windowHeight / 2);
		return new XYConstraints(x, y, windowWidth, windowHeight);
	}

	/**
	  * This function initiates the functioning of the ApplicationHandler.
	  * This function is required as the application handler will not immediately start
	  * operation until it is handed the socket by the main handling system.
	  * @param newConnection The Socket which is connected to the page in operation. If null uses the connection already set.
	  * @exception java.lang.IllegalThreadStateException containing any problems.
	*/
	public synchronized void start(Socket newConnection)
		throws IllegalThreadStateException {
		super.start(newConnection);
		setUp();
	}

	/**
		* This function is called when the program first starts.
		* Insert into here any initial set up code you may require.
	*/
	public void setUp() {
		try {
			// Add any setup logic required here
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	/**
	 * Method: getStocks
	 * This method is being used for getting all the stocks.
	 * @return Stock_Data[] The retrieved stocks. 
	 */
	public Stock_Data[] getStocks() {
		return stocks;
	}


	/**
	 * This method is being used for setting user details.
	 * @param u The user details. 
	 * @return void
	 */
	public void setUser(User_Data u) {
		this.user = u;
	}

	/**
	 * This method is being used for getting user details.
	 * @return User_Data The user details.
	 */
	public User_Data getUser() {
		return this.user;
	}

	
	/**
	 * This method is being used for setting the address data.
	 * @param a The address details.
	 * @return void
	 */
	public void setAddress(UserAddress_Data a) {
		this.address = a;
	}

	/**
	 * This method is being used for getting the address details.
	 * @return UserAddress_Data Address details.
	 */
	public UserAddress_Data getAddress() {
		return this.address;
	}
}
